import sys
import webbrowser
from PyQt5.QtWidgets import *
from PyQt5 import uic
from PyQt5.QtCore import *
import nesw_col
import threading
import pymysql.cursors
from PyQt5.QtChart import QChart, QChartView, QPieSeries
from PyQt5.QtGui import *


form = uic.loadUiType("news.ui")[0]

conn = pymysql.connect(host='183.99.87.90',
        user='root',
        password='swhacademy!',
        db = 'LeeHyunJin',
        charset='utf8')

class db_col(QMainWindow):
    def __init__(self, link):
        super().__init__()
        self.link = link
        self.collect()

    def collect(self):
        try:
            with conn.cursor() as cursor:
                sql2 = "SELECT in_word, polar FROM cor_word WHERE cor_word.up_doc = '%s';" % self.link
                #print(sql2)
                cursor.execute(sql2)
                self.results2 = cursor.fetchall()
                #for result in self.results2:
                 #   print(result)
        finally:
            self.main()

    def main(self):
        pass


class MyWindow3(db_col):
    def __init__(self,link):
        super().__init__(link)
        self.setGeometry(600, 100, 680, 600)
        self.show()

        self.select = 0
        self.slice = None


    def main(self):
        self.di_dt = dict()
        self.ind_li = []
        self.word_li = []

        self.series = QPieSeries()
        #self.series.append("ll", 70)

        for b in self.results2:
            if b[0] not in self.di_dt:
                self.di_dt[b[0]] = b[1]
            else:
                self.di_dt[b[0]] =  (self.di_dt[b[0]] + b[1])

        for i in self.results2:
            if i[0] not in self.word_li:
                self.series.append(i[0], int(i[1]))
                self.word_li.append(i[0])
                if int(i[1]) > 0:
                    self.ind_li.append(1)
                elif int(i[1]) < 0:
                    self.ind_li.append(0)
                else:
                    pass
            else:
                pass

        print(self.ind_li)
        print(self.word_li)

        # adding slice
        self.series.doubleClicked.connect(self.series_clickEvent)

        # self.slice = self.series.slices()[0]
        # self.slice.setBrush(Qt.blue)
        # print(self.slice.value())


        for i in range(self.series.count()):
            self.slice = self.series.slices()[i]
            #print(self.slice.value())
            if self.ind_li[i] == 1:
                self.slice.setBrush(Qt.red)
            elif self.ind_li[i] == 0:
                self.slice.setBrush(Qt.blue)


        #self.slice.setExploded(True)
        #self.slice.setLabelVisible(True)
        #self.slice.setPen(QPen(Qt.darkGreen, 2))

        chart = QChart()
        chart.legend().hide()
        chart.addSeries(self.series)
        chart.createDefaultAxes()
        #chart.setAnimationOptions(QChart.SeriesAnimations)
        chart.setTitle("Pie Chart Example")

        chart.legend().setVisible(True)
        chart.legend().setAlignment(Qt.AlignBottom)

        chartview = QChartView(chart)
        chartview.setRenderHint(QPainter.Antialiasing)

        self.setCentralWidget(chartview)

    def series_clickEvent(self, slice):
        self.slice = self.series.slices()[self.select]
        print(4)
        for i in range(self.series.count()):
            print(self.series.slices()[i])

        self.slice.setExploded(True)
        self.slice.setLabelVisible(True)
        #self.slice.setPen(QPen(Qt.darkGreen, 2))
        #self.slice.setBrush(Qt.green)

        self.select = self.select + 1
        # self.slice = self.series.slices()[self.select]
        print(self.select)
        print(slice.label(), slice.value())

        self.series.slices().clear()


class MyWindow2(db_col):
    def __init__(self, link):
        print(1)
        super().__init__(link)
        print(2)
        # self.link = link
    #     self.col_DB()
    #
    # def col_DB(self):
    #     try:
    #         with conn.cursor() as cursor:
    #             sql2 = "SELECT in_word, polar FROM cor_word WHERE cor_word.up_doc = '%s';" % self.link
    #             #print(sql2)
    #             cursor.execute(sql2)
    #             self.results2 = cursor.fetchall()
    #             #for result in self.results2:
    #              #   print(result)
    #     finally:
    #         #conn.close()
    #         self.main()

    def main(self):

        self.tableWidget = QTableWidget(self)

        centerGeometry = QDesktopWidget().availableGeometry().center()
        self.resize(200, 600)
        frameGeometry = self.frameGeometry()
        frameGeometry.moveCenter(centerGeometry)

        self.rows2 = self.results2
        headers2 = ["명사", "반응"]

        self.tableWidget.setRowCount(len(self.rows2))
        self.tableWidget.setColumnCount(len(headers2))
        self.tableWidget.resize(400, 800)
        self.tableWidget.setHorizontalHeaderLabels(headers2)
        self.setTableWidgetData2()


    def setTableWidgetData2(self):
        for b in range(len(self.rows2)):
            for c in range(len(self.rows2[b])):
                item = QTableWidgetItem(self.rows2[b][c])
                if c == 0:
                   item.setTextAlignment(Qt.AlignRight)
                self.tableWidget.setItem(b, c, item)

        self.tableWidget.resizeColumnsToContents()
        self.tableWidget.resizeRowsToContents()


class MyWindow(QMainWindow, form):
    def __init__(self):
        super().__init__()
        self.setupUi(self)
        self.cate_sid = {"정치": (100, 269), "경제": (101, 263), "사회": (102, 257), "문화": (103, 245), "세계": (104, 322),
                         "과학": (105, 228), "IT": (105, 230)}


        self.pushButton.clicked.connect(self.main)


    def worker(self):
        #self.inf_li, url_li = nesw_col.collect(self.cate_sid.get(self.topic)[0], self.cate_sid.get(self.topic)[1])
        self.category()

    def main(self):
        #th = threading.Thread(target=self.worker)
        self.topic = self.comboBox.currentText()
        self.select_DB(self.topic)
        self.worker()
        #th.start()  # 생성한 스레드를 시작한다
        # self.category()

    def category(self):

        #print(self.inf_li)

        self.rows = self.results
        self.headers = ["제공회사", "제목", "날짜","주소", "반응", "nn","mm"]

        self.tableWidget.setRowCount(len(self.rows))
        self.tableWidget.setColumnCount(len(self.headers))

        self.setTableWidgetData()


    def select_DB(self, topic):
        with conn.cursor() as cursor:
            sql = "SELECT firm, name, date, url, resp FROM news WHERE news.topic = '%s'" % topic
            cursor.execute(sql)
            self.results = cursor.fetchall()



            # sql2 = "SELECT url FROM news WHERE news.topic = '%s' " % topic
            # cursor.execute(sql2)
            # self.results2 = cursor.fetchall()

            #print(self.results2)

        return self.results

    def setTableWidgetData(self):
        for b in range(len(self.rows)):
            for c in range(len(self.rows[b])):
                btn = QPushButton("명사")
                btn2 = QPushButton("차트")
                item = QTableWidgetItem(self.rows[b][c])
                #if c == 0:
                #item.setTextAlignment(Qt.AlignRight)
                self.tableWidget.setItem(b, c, item)
            self.tableWidget.setCellWidget(b, 5, btn)
            self.tableWidget.setCellWidget(b, 6, btn2)
            btn.clicked.connect(self.btn_fun)
            btn2.clicked.connect(self.btn2_chart)
        #self.tableWidget.resizeColumnsToContents()
        #self.tableWidget.resizeRowsToContents()

    def btn_fun(self):
        #print(self.sender())

        item = self.tableWidget.indexAt(self.sender().pos())
        url_link = self.tableWidget.item(item.row(), 3).text()
        #webbrowser.open_new(url_link)
        self.window2 = MyWindow2(url_link)
        self.window2.show()

    def btn2_chart(self):
        item = self.tableWidget.indexAt(self.sender().pos())
        url_link = self.tableWidget.item(item.row(), 3).text()

        self.window3 = MyWindow3(url_link)
        self.window3.show()


if __name__ == '__main__':
    app = QApplication(sys.argv)
    window = MyWindow()
    window.show()
    sys.exit(app.exec_())
